//=============================================================================
// BattleEffectPopup_ExtraCritical_Attachment.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2022/08/27 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================
/*:
 * @plugindesc 戦闘行動結果ポップアッププラグイン_多段クリティカル機構アタッチメント
 * @target MZ
 * @author くろあめ
 * 
 * @param CrtStr_Lv1
 * @text 第一クリティカルポップアップ
 * @desc 第一クリティカル成功時のポップアップです。
 * @default Critical!
 * @type text
 *
 * @param CrtStr_Lv2
 * @text 第二クリティカルポップアップ
 * @desc 第二クリティカル成功時のポップアップです。
 * @default Heavy Critical!
 * @type text
 *
 * @param CrtStr_Lv3
 * @text 第三クリティカルポップアップ
 * @desc 第三クリティカル成功時のポップアップです。
 * @default Buster Critical!
 * @type text
 *
 * @param Critical
 * @text クリティカルポップアップ
 * @desc クリティカル発生時のポップアップ情報です。
 * @type struct<Popup>
 * @default {"text":"Critical","fileName":"","stateId":"","color":"","flash":"","se":""}
 *
 * @param Weakness
 * @text 弱点ポップアップ
 * @desc 弱点時のポップアップ情報です。
 * @type struct<Popup>
 * @default {"text":"Weakness","fileName":"","stateId":"","color":"","flash":"","se":""}
 * 
 * @param Resistance
 * @text 耐性ポップアップ
 * @desc 耐性時のポップアップ情報です。
 * @type struct<Popup>
 * @default {"text":"Resist","fileName":"","stateId":"","color":"","flash":"","se":""}
 *
 * @help
 * トリアコンタン氏の戦闘行動結果ポップアッププラグインの
 * クリティカル時のポップアップを、多段クリティカル機構に合わせたものに変更します
 * 双方の導入が動作の前提条件です。両プラグインより下に配置してください。
 *
 * クリティカルポップアップ、弱点ポップアップの挙動については
 * このプラグインで定義されたパラメータで動作します
 * ポップアップ設定側のテキストは無視されます。
 *
 * 本プラグインについての質問は、くろあめ宛てでお願いします
 * トリアコンタン氏は、本プラグインの作成には関わっていません。
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的にサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 *
*/

/*~struct~Popup:
 * 
 * @param text
 * @text ポップアップテキスト
 * @desc ポップアップテキストです。
 * 
 * @param fileName
 * @text ポップアップファイル
 * @desc ポップアップする画像ファイルです。指定した場合、テキスト表示より優先されます。
 * @type file
 * @dir img/pictures
 *
 * @param stateId
 * @text ステートID
 * @desc ポップアップ表示対象のステートIDです。ステートリスト以外では指定不要です。
 * @type state
 *
 * @param color
 * @text ポップアップカラー
 * @desc ポップアップカラーです。CSSの色指定文字列を指定します。
 * @default
 * @type combo
 * @option rgba(255, 255, 255, 1.0)
 * @option hsla(60, 100%, 50%, 1.0)
 * @option #99FF66
 * @option black
 * @option silver
 * @option gray
 * @option white
 * @option maroon
 * @option red
 * @option purple
 * @option fuchsia
 * @option green
 * @option lime
 * @option olive
 * @option yellow
 * @option navy
 * @option blue
 * @option teal
 * @option aqua
 *
 * @param textSize
 * @text テキストサイズ
 * @desc ポップアップテキストのサイズです。0を指定した場合、デフォルトサイズとなります。
 * @default 0
 *
 * @param flash
 * @text フラッシュ
 * @desc ポップアップ時のフラッシュカラーです。
 * @type struct<Color>
 * @default
 *
 * @param se
 * @text 効果音
 * @desc ポップアップ時の効果音です。
 * @type struct<SE>
 * @default
 *
 */

/*~struct~Color:
 *
 * @param red
 * @text 赤色
 * @desc フラッシュの赤色の度合いです。
 * @default 255
 * @type number
 * @max 255
 *
 * @param green
 * @text 緑色
 * @desc フラッシュの緑色の度合いです。
 * @default 255
 * @type number
 * @max 255
 *
 * @param blue
 * @text 青色
 * @desc フラッシュの青色の度合いです。
 * @default 255
 * @type number
 * @max 255
 *
 * @param alpha
 * @text 強さ
 * @desc フラッシュの強さです。
 * @default 0
 * @type number
 * @max 255
 */

/*~struct~SE:
 *
 * @param name
 * @text ファイル名
 * @desc ファイル名です。
 * @require 1
 * @dir audio/se/
 * @type file
 * @default
 *
 * @param volume
 * @text ボリューム
 * @desc ボリュームです。
 * @type number
 * @default 90
 * @min 0
 * @max 100
 *
 * @param pitch
 * @text ピッチ
 * @desc ピッチです。
 * @type number
 * @default 100
 * @min 50
 * @max 150
 *
 * @param pan
 * @text 定位
 * @desc 定位(左右バランス)です。
 * @type number
 * @default 0
 * @min -100
 * @max 100
 */

(function() {

    'use strict';
    const script = document.currentScript;
    const param = PluginManagerEx.createParameter(script);
    
    const _Game_ActionResult_findResultPopup_excri = Game_ActionResult.prototype.findResultPopup;
    Game_ActionResult.prototype.findResultPopup = function() {
        let plusText = "";
        if (this.elementRate) {
            if (this.elementRate >= 1.01) {
                plusText =  "  " + param.Weakness._parameter.text; 
            } else if (this.elementRate <= 0.99) {
                plusText =  "  " + param.Resistance._parameter.text; 
            }
        }
        
        //target.appointMessagePopup(param.Weakness);
        //target.appointMessagePopup(param.Resistance);

        if (this.critical) {
            const ret = param.Critical;
            if(this.critical_lv > 2){
               ret._parameter.text = param.CrtStr_Lv3 + plusText;               
            }
            else if(this.critical_lv > 1){
               ret._parameter.text = param.CrtStr_Lv2 + plusText;
            }
            else{
               ret._parameter.text = param.CrtStr_Lv1 + plusText;
            }
            return ret;
        } else if(this.elementRate && this.hpDamage > 0){
            if (this.elementRate >= 1.01) {
                return param.Weakness; 
            } else if (this.elementRate <= 0.99) {
                return param.Resistance; 
            }
        }
        return _Game_ActionResult_findResultPopup_excri.apply(this, arguments);
    };
    
})();